"""Add size to parcels

Revision ID: e44a6f304d17
Revises: ad2b49f5d70a
Create Date: 2022-01-04 09:41:38.972167

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "e44a6f304d17"
down_revision = "ad2b49f5d70a"
SIZES = {
    103: 737,
    81: 405,
    104: 333,
    82: 388,
    105: 283,
    83: 438,
    107: 286,
    106: 603,
    84: 583,
    109: 338,
    108: 635,
    85: 600,
    111: 356,
    110: 408,
    189: 337,
    86: 468,
    113: 285,
    87: 956,
    114: 295,
    112: 380,
    149: 298,
    190: 118,
    150: 674,
    88: 503,
    116: 272,
    206: 314,
    151: 314,
    118: 315,
    115: 348,
    153: 275,
    152: 403,
    171: 373,
    89: 332,
    90: 661,
    91: 719,
    121: 360,
    154: 425,
    174: 320,
    172: 429,
    95: 427,
    93: 427,
    123: 342,
    119: 407,
    155: 346,
    207: 169,
    191: 170,
    176: 702,
    97: 372,
    124: 324,
    99: 393,
    125: 347,
    120: 371,
    156: 305,
    195: 377,
    143: 420,
    100: 394,
    127: 277,
    122: 354,
    158: 287,
    157: 450,
    178: 334,
    175: 577,
    177: 612,
    197: 492,
    198: 598,
    101: 394,
    129: 311,
    102: 618,
    131: 296,
    187: 431,
    133: 336,
    202: 174,
    204: 175,
    160: 312,
    126: 203,
    128: 204,
    161: 373,
    159: 273,
    179: 289,
    188: 300,
    135: 399,
    130: 370,
    163: 361,
    193: 65,
    162: 545,
    180: 380,
    181: 714,
    137: 425,
    139: 407,
    132: 173,
    134: 155,
    164: 259,
    142: 430,
    136: 306,
    192: 260,
    199: 137,
    182: 397,
    183: 541,
    184: 518,
    144: 496,
    138: 317,
    166: 276,
    165: 387,
    185: 578,
    145: 433,
    140: 319,
    167: 317,
    147: 411,
    146: 369,
    141: 324,
    168: 297,
    186: 497,
    194: 868,
    196: 313,
    148: 1200,
    205: 375,
    117: 375,
    169: 2111,
}


def upgrade():
    op.add_column("parcel", sa.Column("size", sa.Integer(), nullable=True))
    for parcel, size in SIZES.items():
        op.execute(f"UPDATE parcel SET size = {size} WHERE id = {parcel}")


def downgrade():
    op.drop_column("parcel", "size")
