"""Add budgets to accounting

Revision ID: 53f3d16657d3
Revises: 92cec0e8663e
Create Date: 2020-12-29 14:44:13.423851

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "53f3d16657d3"
down_revision = "92cec0e8663e"

BOOKING_KINDS = {
    "Mitgliedsbeitrag": 1,
    "Energieabschlag I": 3,
    "Energieabschlag II": 4,
    "Energieabrechnung": 5,
    "Grundsteuer B": 6,
    "Abwasser": 7,
    "Aufnahmegebühr": 13,
    "Grundbesitzabgabe": 14,
    "Versicherungen": 15,
    "Verwaltung": 16,
    "Aufwandsentschädigungen": 17,
    "Instandhaltung": 18,
    "Energieanbieter": 19,
    "Müll": 20,
    "Vereinsfest": 21,
    "Pacht": 22,
    "Körperschaftssteuer": 23,
    "Arbeitsstunden": 2,
    "Mahn- & Zusatzleistungen": 24,
    "sonstige Einnahmen": 25,
    "sonstige Ausgaben": 26,
    "Satellitenanlage": 27,
}

DATA = {
    2015: {
        "Mitgliedsbeitrag": 64800000,
        "Aufnahmegebühr": 500000,
        "Mahn- & Zusatzleistungen": 0,
        "Arbeitsstunden": 15000000,
        "Körperschaftssteuer": 0,
        "sonstige Einnahmen": 600000,
        "Pacht": 6250000,
        "Verwaltung": -20000000,
        "Versicherungen": -6200000,
        "Müll": -11000000,
        "Abwasser": -700000,
        "Instandhaltung": -50000000,
        "Aufwandsentschädigungen": -8400000,
        "Grundsteuer B": -490000,
        "Grundbesitzabgabe": -650000,
        "sonstige Ausgaben": -2000000,
        "Vereinsfest": 0,
        "Satellitenanlage": -5000000,
        "Energieabrechnung": 0,
        "Energieanbieter": 0,
        "Energieabschlag I": 0,
        "Energieabschlag II": 0,
    },
    2016: {
        "Mitgliedsbeitrag": 79500000,
        "Aufnahmegebühr": 500000,
        "Mahn- & Zusatzleistungen": 0,
        "Arbeitsstunden": 10000000,
        "Körperschaftssteuer": 0,
        "sonstige Einnahmen": 0,
        "Pacht": 7000000,
        "Verwaltung": -7000000,
        "Versicherungen": -6000000,
        "Müll": -9500000,
        "Abwasser": -600000,
        "Instandhaltung": -50000000,
        "Aufwandsentschädigungen": -8600000,
        "Grundsteuer B": -490000,
        "Grundbesitzabgabe": -200000,
        "sonstige Ausgaben": -2000000,
        "Vereinsfest": 0,
        "Satellitenanlage": -5000000,
        "Energieabrechnung": 0,
        "Energieanbieter": 0,
        "Energieabschlag I": 0,
        "Energieabschlag II": 0,
    },
    2017: {
        "Mitgliedsbeitrag": 80250000,
        "Aufnahmegebühr": 1000000,
        "Mahn- & Zusatzleistungen": 0,
        "Arbeitsstunden": 13000000,
        "Körperschaftssteuer": 0,
        "sonstige Einnahmen": 0,
        "Pacht": 6203900,
        "Verwaltung": -7000000,
        "Versicherungen": -6300000,
        "Müll": -10000000,
        "Abwasser": 0,
        "Instandhaltung": -40000000,
        "Aufwandsentschädigungen": -9000000,
        "Grundsteuer B": -494100,
        "Grundbesitzabgabe": -200700,
        "sonstige Ausgaben": -3000000,
        "Vereinsfest": -20000000,
        "Satellitenanlage": -5000000,
        "Energieabrechnung": 0,
        "Energieanbieter": 0,
        "Energieabschlag I": 0,
        "Energieabschlag II": 0,
    },
    2018: {
        "Mitgliedsbeitrag": 68900000,
        "Aufnahmegebühr": 1000000,
        "Mahn- & Zusatzleistungen": 0,
        "Arbeitsstunden": 15000000,
        "Körperschaftssteuer": 50000,
        "sonstige Einnahmen": 0,
        "Pacht": 6203900,
        "Verwaltung": -7500000,
        "Versicherungen": -6000000,
        "Müll": -12000000,
        "Abwasser": 0,
        "Instandhaltung": -55000000,
        "Aufwandsentschädigungen": -9000000,
        "Grundsteuer B": -494100,
        "Grundbesitzabgabe": -198600,
        "sonstige Ausgaben": -3000000,
        "Vereinsfest": 0,
        "Satellitenanlage": -5000000,
        "Energieabrechnung": 0,
        "Energieanbieter": 0,
        "Energieabschlag I": 0,
        "Energieabschlag II": 0,
    },
    2019: {
        "Mitgliedsbeitrag": 80250000,
        "Aufnahmegebühr": 250000,
        "Mahn- & Zusatzleistungen": 500000,
        "Arbeitsstunden": 13000000,
        "Körperschaftssteuer": 30000,
        "sonstige Einnahmen": 0,
        "Pacht": 6203900,
        "Verwaltung": -7000000,
        "Versicherungen": -6300000,
        "Müll": -11000000,
        "Abwasser": -600000,
        "Instandhaltung": -55000000,
        "Aufwandsentschädigungen": -8400000,
        "Grundsteuer B": -494100,
        "Grundbesitzabgabe": -198600,
        "sonstige Ausgaben": -3000000,
        "Vereinsfest": 0,
        "Satellitenanlage": -5000000,
        "Energieabrechnung": -2000000,
        "Energieanbieter": 0,
        "Energieabschlag I": 0,
        "Energieabschlag II": 0,
    },
    2020: {
        "Mitgliedsbeitrag": 79500000,
        "Aufnahmegebühr": 500000,
        "Mahn- & Zusatzleistungen": 500000,
        "Arbeitsstunden": 13000000,
        "Körperschaftssteuer": 0,
        "sonstige Einnahmen": 0,
        "Pacht": 6203900,
        "Verwaltung": -7500000,
        "Versicherungen": -6000000,
        "Müll": -12000000,
        "Abwasser": -600000,
        "Instandhaltung": -55000000,
        "Aufwandsentschädigungen": -9000000,
        "Grundsteuer B": -494100,
        "Grundbesitzabgabe": -201100,
        "sonstige Ausgaben": -3000000,
        "Vereinsfest": 0,
        "Satellitenanlage": -5000000,
        "Energieabrechnung": 0,
        "Energieanbieter": 0,
        "Energieabschlag I": 0,
        "Energieabschlag II": 0,
    },
    2021: {
        "Mitgliedsbeitrag": 78750000,
        "Aufnahmegebühr": 500000,
        "Mahn- & Zusatzleistungen": 300000,
        "Arbeitsstunden": 14000000,
        "Körperschaftssteuer": 0,
        "sonstige Einnahmen": 0,
        "Pacht": 6203900,
        "Verwaltung": -7000000,
        "Versicherungen": -8058300,
        "Müll": -12000000,
        "Abwasser": -600000,
        "Instandhaltung": -55000000,
        "Aufwandsentschädigungen": -8400000,
        "Grundsteuer B": -494100,
        "Grundbesitzabgabe": -202100,
        "sonstige Ausgaben": -3000000,
        "Vereinsfest": 0,
        "Satellitenanlage": -5000000,
        "Energieabrechnung": -2000000,
        "Energieanbieter": 0,
        "Energieabschlag I": 0,
        "Energieabschlag II": 0,
    },
}


def upgrade():
    op.create_table(
        "budget",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("organization_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Integer(), nullable=True),
        sa.Column("accounting_year", sa.Integer(), nullable=True),
        sa.Column("booking_kind_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["booking_kind_id"],
            ["bookingkind.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    for year, budgets in DATA.items():
        for kind, amount in DATA[year].items():
            id_ = BOOKING_KINDS[kind]
            op.execute(f"""
INSERT into budget (booking_kind_id, accounting_year, value, organization_id)
VALUES ({id_}, {year}, {amount}, 1);
""")


def downgrade():
    op.drop_table("budget")
